using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
		      int a;
		      TLineAnnotParms p;
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();
               double w = 300.0;
               double h = 100.0;
               double x = pdf.GetPageWidth()  / 2;
               double y = pdf.GetPageHeight() / 2;

               // We save the graphics state because the coordinate system will be rotated.
               // After RestoreGraphicState() we have the non-rotated coordinate system back.
               pdf.SaveGraphicState();

                  pdf.SetGStateFlags(TGStateFlags.gfRealTopDownCoords, false); // This simplifies the handling a little bit.
                  pdf.RotateCoords(-30, x, y);

                  x = -w / 2;
                  y = -h / 2;

                  pdf.SetFillColor(CPDF.PDF_CREAM);
                  pdf.Rectangle(x, y, w, h, TPathFillMode.fmFillStroke);

                  String txt = String.Format("{0:0.0}", w);
                  a = pdf.LineAnnot(x, y, x + w, y, 1.0, TLineEndStyle.leClosedArrow, TLineEndStyle.leClosedArrow, CPDF.PDF_BLACK, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "This is a measure line", "Measure Line", txt);

                  p = new TLineAnnotParms();
                  p.Caption          = 1;     // The parameter Content of LineAnnot() is used as caption.
                  p.LeaderLineLen    = 10.0f;
                  p.LeaderLineExtend = 4.0f;  // Try different values to understand what these parameters change.
                  p.LeaderLineOffset = 2.0f;
                  pdf.SetLineAnnotParms(a, -1, 0.0, p);

                  txt = String.Format("{0:0.0}", h);
                  a = pdf.LineAnnot(x, y+h, x, y, 1.0, TLineEndStyle.leClosedArrow, TLineEndStyle.leClosedArrow, CPDF.PDF_BLACK, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "This is a measure line", "Measure Line", txt);
                  // The parameters are exactly the same as above
                  pdf.SetLineAnnotParms(a, -1, 0.0, p);

               pdf.RestoreGraphicState();
            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process pcs = new System.Diagnostics.Process();
                  pcs.StartInfo.FileName = filePath;
                  pcs.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
